#pragma once
//----------------------------------------------------------------------------
#define REECOM_DMA_CHAN_MAX				4
//---------------------------------------------------------------------
typedef struct {
	__volatile__ unsigned long rx_size[REECOM_DMA_CHAN_MAX];
	__volatile__ unsigned long tx_size[REECOM_DMA_CHAN_MAX];
} reecom_dma_state_t;
//----------------------------------------------------------------------------
typedef struct {
	void *data;
	size_t szdata;
	unsigned int channel;
} reecom_dma_rwop_t;
//----------------------------------------------------------------------------
// CTRL -> [RX,...] -> [TX,...] -> STATE
typedef struct {
	unsigned long ctrl_size;
	unsigned long state_size;
	unsigned long rx_size[REECOM_DMA_CHAN_MAX];
	unsigned long tx_size[REECOM_DMA_CHAN_MAX];
	unsigned int rx_count;
	unsigned int tx_count;
} reecom_dma_mapping_t;
//----------------------------------------------------------------------------
#define REECOM_DMA_GET_MAPPING			_IOR('r', 2, reecom_dma_mapping_t*)
#define REECOM_DMA_CHAN_READ			_IOR('r', 1, reecom_dma_rwop_t*)
#define REECOM_DMA_CHAN_WRITE			_IOW('r', 1, reecom_dma_rwop_t*)
